﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class TerminatedLevels : UserControl
    {
        private ToneGenerator Gen;
        private ISignalMeter Meter;
        private ITelephoneInterface TelInt;

        private SignalLevel Result = SignalLevel.InVrms(0);

        public TerminatedLevels()
        {
            InitializeComponent();
            this.EnabledChanged += new EventHandler(TerminatedLevels_EnabledChanged);

            cbo_TerminationZ.Items.Clear();

            cbo_TerminationZ.Items.Add("Nothing (open Circuit)");
            cbo_TerminationZ.Items.Add(Impedance.Resistive_600);
            cbo_TerminationZ.Items.Add(Impedance.Resistive_900);
            cbo_TerminationZ.Items.Add(Impedance.TBR_21);
            cbo_TerminationZ.Items.Add(Impedance.German_ZR);
            cbo_TerminationZ.SelectedIndex = 1;
        }

        void TerminatedLevels_EnabledChanged(object sender, EventArgs e)
        {
            timer_update.Enabled = this.Enabled;
        }

        public void SetSupportObjects(ToneGenerator Gen, ISignalMeter Meter, ITelephoneInterface TelInt)
        {
            this.Gen = Gen;
            this.Meter = Meter;
            this.TelInt = TelInt;
        }

        private void timer_update_Tick(object sender, EventArgs e)
        {
            try
            {
                if ((TelInt == null) || (Gen == null) || (Meter == null)) return;

                Impedance TermZ = null;
                Impedance SourceZ = TelInt.ACImpedance;

                lbl_GeneratorSourceZ.Text = SourceZ.ToString();

                if (rb_ComplexZ.Checked)
                {
                    TermZ = cbo_TerminationZ.SelectedItem as Impedance;
                }
                else
                {
                    double R;

                    if ((!double.TryParse(txt_Resistance.Text, out R)) || (R <= 0)) throw new Exception("Invalid resistance");

                    TermZ = ResistiveImpedance.InOhms(R);
                }

                // Calcuate the required generator level based on this termination
                Result = SignalLevel.CalculateGeneratorLevel(level_Desired.Level,
                                                        freq_Desired.Freq,
                                                        SourceZ,
                                                        TermZ);
                Result = Result.ToRepresentation(level_Desired.Level.Specification);
              

                lbl_GeneratorLevel.Text = Result.ToString();

                lbl_DesiredSignal.Text = level_Desired.Level.ToString() + " @ " + freq_Desired.Freq.ToString();

                SignalLevel Level;
                Frequency Freq;
                Meter.GetMeasurements(out Level, out Freq);

                lbl_MeasuredSignal.Text = Level.ToRepresentation(level_Desired.Level.Specification).ToString() + " @ " + Freq.ToString();
                
    
            }
            catch
            {
                lbl_GeneratorLevel.Text = "?";
            }
        }

        private void btn_Generate_Click(object sender, EventArgs e)
        {
            try
            {
                Gen.StopGenerator();
                Gen.Generate(new Tone(Result, freq_Desired.Freq), Phase.InDegrees(0));
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }
    }
}
